"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearchObjectType = getSavedSearchObjectType;
var _configSchema = require("@kbn/config-schema");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../common");
var _search_migrations = require("./search_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSavedSearchObjectType(getSearchSourceMigrations) {
  return {
    name: 'search',
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    management: {
      icon: 'discoverApp',
      defaultSearchField: 'title',
      importableAndExportable: true,
      getTitle(obj) {
        return obj.attributes.title;
      },
      getInAppUrl(obj) {
        return {
          path: `/app/discover#/view/${encodeURIComponent(obj.id)}`,
          uiCapabilitiesPath: 'discover.show'
        };
      }
    },
    mappings: {
      dynamic: false,
      properties: {
        title: {
          type: 'text'
        },
        description: {
          type: 'text'
        }
      }
    },
    schemas: {
      '8.8.0': _configSchema.schema.object({
        // General
        title: _configSchema.schema.string(),
        description: _configSchema.schema.string({
          defaultValue: ''
        }),
        // Data grid
        columns: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          defaultValue: []
        }),
        sort: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
          maxSize: 2
        })), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          maxSize: 2
        })], {
          defaultValue: []
        }),
        grid: _configSchema.schema.object({
          columns: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
            width: _configSchema.schema.maybe(_configSchema.schema.number())
          })))
        }, {
          defaultValue: {}
        }),
        rowHeight: _configSchema.schema.maybe(_configSchema.schema.number()),
        rowsPerPage: _configSchema.schema.maybe(_configSchema.schema.number()),
        // Chart
        hideChart: _configSchema.schema.boolean({
          defaultValue: false
        }),
        breakdownField: _configSchema.schema.maybe(_configSchema.schema.string()),
        // Search
        kibanaSavedObjectMeta: _configSchema.schema.object({
          searchSourceJSON: _configSchema.schema.string()
        }),
        isTextBasedQuery: _configSchema.schema.boolean({
          defaultValue: false
        }),
        usesAdHocDataView: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        // Time
        timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        timeRange: _configSchema.schema.maybe(_configSchema.schema.object({
          from: _configSchema.schema.string(),
          to: _configSchema.schema.string()
        })),
        refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
          pause: _configSchema.schema.boolean(),
          value: _configSchema.schema.number()
        })),
        // Display
        viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.VIEW_MODE.DOCUMENT_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.AGGREGATED_LEVEL)])),
        hideAggregatedPreview: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        // Legacy
        hits: _configSchema.schema.maybe(_configSchema.schema.number()),
        version: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    },
    migrations: () => (0, _search_migrations.getAllMigrations)(getSearchSourceMigrations())
  };
}