"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromSavedSearchAttributes = void 0;
Object.defineProperty(exports, "getSavedSearchFullPathUrl", {
  enumerable: true,
  get: function () {
    return _common.getSavedSearchFullPathUrl;
  }
});
Object.defineProperty(exports, "getSavedSearchUrl", {
  enumerable: true,
  get: function () {
    return _common.getSavedSearchUrl;
  }
});
exports.toSavedSearchAttributes = exports.throwErrorOnSavedSearchUrlConflict = exports.getSavedSearchUrlConflictMessage = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getSavedSearchUrlConflictMessage = async savedSearch => {
  var _savedSearch$sharingS;
  return _i18n.i18n.translate('savedSearch.legacyURLConflict.errorMessage', {
    defaultMessage: `This search has the same URL as a legacy alias. Disable the alias to resolve this error : {json}`,
    values: {
      json: (_savedSearch$sharingS = savedSearch.sharingSavedObjectProps) === null || _savedSearch$sharingS === void 0 ? void 0 : _savedSearch$sharingS.errorJSON
    }
  });
};
exports.getSavedSearchUrlConflictMessage = getSavedSearchUrlConflictMessage;
const throwErrorOnSavedSearchUrlConflict = async savedSearch => {
  var _savedSearch$sharingS2;
  if ((_savedSearch$sharingS2 = savedSearch.sharingSavedObjectProps) !== null && _savedSearch$sharingS2 !== void 0 && _savedSearch$sharingS2.errorJSON) {
    throw new Error(await getSavedSearchUrlConflictMessage(savedSearch));
  }
};
exports.throwErrorOnSavedSearchUrlConflict = throwErrorOnSavedSearchUrlConflict;
const fromSavedSearchAttributes = (id, attributes, tags, searchSource, sharingSavedObjectProps) => ({
  ...(0, _common.fromSavedSearchAttributes)(id, attributes, tags, searchSource),
  sharingSavedObjectProps
});
exports.fromSavedSearchAttributes = fromSavedSearchAttributes;
const toSavedSearchAttributes = (savedSearch, searchSourceJSON) => {
  var _savedSearch$title, _savedSearch$sort, _savedSearch$columns, _savedSearch$descript, _savedSearch$grid, _savedSearch$hideChar, _savedSearch$isTextBa, _savedSearch$timeRest;
  return {
    kibanaSavedObjectMeta: {
      searchSourceJSON
    },
    title: (_savedSearch$title = savedSearch.title) !== null && _savedSearch$title !== void 0 ? _savedSearch$title : '',
    sort: (_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [],
    columns: (_savedSearch$columns = savedSearch.columns) !== null && _savedSearch$columns !== void 0 ? _savedSearch$columns : [],
    description: (_savedSearch$descript = savedSearch.description) !== null && _savedSearch$descript !== void 0 ? _savedSearch$descript : '',
    grid: (_savedSearch$grid = savedSearch.grid) !== null && _savedSearch$grid !== void 0 ? _savedSearch$grid : {},
    hideChart: (_savedSearch$hideChar = savedSearch.hideChart) !== null && _savedSearch$hideChar !== void 0 ? _savedSearch$hideChar : false,
    viewMode: savedSearch.viewMode,
    hideAggregatedPreview: savedSearch.hideAggregatedPreview,
    rowHeight: savedSearch.rowHeight,
    isTextBasedQuery: (_savedSearch$isTextBa = savedSearch.isTextBasedQuery) !== null && _savedSearch$isTextBa !== void 0 ? _savedSearch$isTextBa : false,
    usesAdHocDataView: savedSearch.usesAdHocDataView,
    timeRestore: (_savedSearch$timeRest = savedSearch.timeRestore) !== null && _savedSearch$timeRest !== void 0 ? _savedSearch$timeRest : false,
    timeRange: savedSearch.timeRange ? (0, _lodash.pick)(savedSearch.timeRange, ['from', 'to']) : undefined,
    refreshInterval: savedSearch.refreshInterval,
    rowsPerPage: savedSearch.rowsPerPage,
    breakdownField: savedSearch.breakdownField
  };
};
exports.toSavedSearchAttributes = toSavedSearchAttributes;