"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveSavedSearch = void 0;
var _constants = require("./constants");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const hasDuplicatedTitle = async (title, savedObjectsClient) => {
  if (!title) {
    return;
  }
  const response = await savedObjectsClient.find({
    type: _constants.SAVED_SEARCH_TYPE,
    perPage: 10,
    search: `"${title}"`,
    searchFields: ['title'],
    fields: ['title']
  });
  return response.savedObjects.some(obj => obj.get('title').toLowerCase() === title.toLowerCase());
};

/** @internal **/
const saveSavedSearch = async (savedSearch, options, savedObjectsClient, savedObjectsTagging) => {
  var _savedSearch$tags;
  const isNew = options.copyOnSave || !savedSearch.id;
  if (savedSearch.title) {
    if (isNew && !options.isTitleDuplicateConfirmed && options.onTitleDuplicate && (await hasDuplicatedTitle(savedSearch.title, savedObjectsClient))) {
      options.onTitleDuplicate();
      return;
    }
  }
  const {
    searchSourceJSON,
    references: originalReferences
  } = savedSearch.searchSource.serialize();
  const references = savedObjectsTagging ? savedObjectsTagging.ui.updateTagsReferences(originalReferences, (_savedSearch$tags = savedSearch.tags) !== null && _savedSearch$tags !== void 0 ? _savedSearch$tags : []) : originalReferences;
  const resp = isNew ? await savedObjectsClient.create(_constants.SAVED_SEARCH_TYPE, (0, _saved_searches_utils.toSavedSearchAttributes)(savedSearch, searchSourceJSON), {
    references
  }) : await savedObjectsClient.update(_constants.SAVED_SEARCH_TYPE, savedSearch.id, (0, _saved_searches_utils.toSavedSearchAttributes)(savedSearch, searchSourceJSON), {
    references
  });
  return resp === null || resp === void 0 ? void 0 : resp.id;
};
exports.saveSavedSearch = saveSavedSearch;