"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearch = void 0;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _constants = require("./constants");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getEmptySavedSearch = ({
  search
}) => ({
  searchSource: search.searchSource.createEmpty()
});
const findSavedSearch = async (savedSearchId, {
  search,
  savedObjectsClient,
  spaces,
  savedObjectsTagging
}) => {
  var _savedSearch$attribut, _savedSearch$attribut2;
  const so = await savedObjectsClient.resolve(_constants.SAVED_SEARCH_TYPE, savedSearchId);
  if (!so.saved_object || so.saved_object.error) {
    throw new _public2.SavedObjectNotFound(_constants.SAVED_SEARCH_TYPE, savedSearchId);
  }
  const savedSearch = so.saved_object;
  const parsedSearchSourceJSON = (0, _public.parseSearchSourceJSON)((_savedSearch$attribut = (_savedSearch$attribut2 = savedSearch.attributes.kibanaSavedObjectMeta) === null || _savedSearch$attribut2 === void 0 ? void 0 : _savedSearch$attribut2.searchSourceJSON) !== null && _savedSearch$attribut !== void 0 ? _savedSearch$attribut : '{}');
  const searchSourceValues = (0, _public.injectSearchSourceReferences)(parsedSearchSourceJSON, savedSearch.references);
  const tags = savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(savedSearch.references) : undefined;
  return (0, _saved_searches_utils.fromSavedSearchAttributes)(savedSearchId, savedSearch.attributes, tags, await search.searchSource.create(searchSourceValues), {
    outcome: so.outcome,
    aliasTargetId: so.alias_target_id,
    aliasPurpose: so.alias_purpose,
    errorJSON: so.outcome === 'conflict' && spaces ? JSON.stringify({
      targetType: _constants.SAVED_SEARCH_TYPE,
      sourceId: savedSearchId,
      targetSpace: (await spaces.getActiveSpace()).id
    }) : undefined
  });
};

/** @public **/
const getSavedSearch = async (savedSearchId, dependencies) => {
  return savedSearchId ? findSavedSearch(savedSearchId, dependencies) : getEmptySavedSearch(dependencies);
};
exports.getSavedSearch = getSavedSearch;