"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
require("./_action_bar.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionToMenuItem = (action, onActionSelected, closePopover) => {
  return {
    name: action.label,
    icon: action.icon,
    onClick: () => {
      closePopover();
      onActionSelected(action);
    },
    'data-test-subj': `actionBar-button-${action.id}`
  };
};
const ActionBar = ({
  actions,
  onActionSelected,
  selectedCount,
  totalCount
}) => {
  const [isPopoverOpened, setPopOverOpened] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(false);
  }, [setPopOverOpened]);
  const togglePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(opened => !opened);
  }, [setPopOverOpened]);
  const contextMenuPanels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: actions.map(action => actionToMenuItem(action, onActionSelected, closePopover))
    }];
  }, [actions, onActionSelected, closePopover]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tagMgt__actionBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.actionBar.totalTagsLabel",
    defaultMessage: "{count, plural, one {1 tag} other {# tags}}",
    values: {
      count: totalCount
    }
  }))), selectedCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tagMgt__actionBarDivider"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpened,
    closePopover: closePopover,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: togglePopover,
      "data-test-subj": "actionBar-contextMenuButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.actionBar.selectedTagsLabel",
      defaultMessage: "{count, plural, one {1 selected tag} other {# selected tags}}",
      values: {
        count: selectedCount
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "tagMgt__actionBarIcon",
      type: "arrowDown",
      size: "s"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: contextMenuPanels,
    "data-test-subj": "actionBar-contextMenu"
  }))))));
};
exports.ActionBar = ActionBar;