"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeleteAction = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeleteAction = ({
  notifications,
  overlays,
  tagClient,
  fetchTags
}) => {
  return {
    id: 'delete',
    name: ({
      name
    }) => _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.delete.title', {
      defaultMessage: 'Delete {name} tag',
      values: {
        name
      }
    }),
    description: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.delete.description', {
      defaultMessage: 'Delete this tag'
    }),
    type: 'icon',
    icon: 'trash',
    onClick: async tag => {
      const confirmed = await overlays.openConfirm(_i18n.i18n.translate('xpack.savedObjectsTagging.modals.confirmDelete.text', {
        defaultMessage: 'By deleting this tag, you will no longer be able to assign it to saved objects. ' + 'This tag will be removed from any saved objects that currently use it.'
      }), {
        title: _i18n.i18n.translate('xpack.savedObjectsTagging.modals.confirmDelete.title', {
          defaultMessage: 'Delete "{name}" tag',
          values: {
            name: tag.name
          }
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.savedObjectsTagging.modals.confirmDelete.confirmButtonText', {
          defaultMessage: 'Delete tag'
        }),
        buttonColor: 'danger',
        maxWidth: 560
      });
      if (confirmed) {
        await tagClient.delete(tag.id);
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.deleteTagSuccessTitle', {
            defaultMessage: 'Deleted "{name}" tag',
            values: {
              name: tag.name
            }
          })
        });
        await fetchTags();
      }
    },
    'data-test-subj': 'tagsTableAction-delete'
  };
};
exports.getDeleteAction = getDeleteAction;