"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTag = exports.useIfMounted = exports.getRandomColor = void 0;
var _react = require("react");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the hex representation of a random color (e.g `#F1B7E2`)
 */
const getRandomColor = () => {
  return '#' + String(Math.floor(Math.random() * 16777215).toString(16)).padStart(6, '0');
};
exports.getRandomColor = getRandomColor;
const validateTag = tag => {
  const validation = {
    valid: true,
    warnings: [],
    errors: {}
  };
  validation.errors.name = (0, _common.validateTagName)(tag.name);
  validation.errors.color = (0, _common.validateTagColor)(tag.color);
  validation.errors.description = (0, _common.validateTagDescription)(tag.description);
  Object.values(validation.errors).forEach(error => {
    if (error) {
      validation.valid = false;
    }
  });
  return validation;
};
exports.validateTag = validateTag;
const useIfMounted = () => {
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => () => {
    isMounted.current = false;
  }, []);
  const ifMounted = (0, _react.useCallback)(func => {
    if (isMounted.current && func) {
      func();
    }
  }, []);
  return ifMounted;
};
exports.useIfMounted = useIfMounted;