"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTagModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _tags = require("../../services/tags");
var _create_or_edit_modal = require("./create_or_edit_modal");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialValidation = {
  valid: true,
  warnings: [],
  errors: {}
};
const getAttributes = tag => {
  const {
    id,
    ...attributes
  } = tag;
  return attributes;
};
const EditTagModal = ({
  tag,
  onSave,
  onClose,
  tagClient
}) => {
  const [validation, setValidation] = (0, _react.useState)(initialValidation);
  const [tagAttributes, setTagAttributes] = (0, _react.useState)(getAttributes(tag));
  const setField = (0, _react.useCallback)(field => value => {
    setTagAttributes(current => ({
      ...current,
      [field]: value
    }));
  }, []);
  const onSubmit = (0, _react.useCallback)(async () => {
    const clientValidation = (0, _utils.validateTag)(tagAttributes);
    setValidation(clientValidation);
    if (!clientValidation.valid) {
      return;
    }
    try {
      const createdTag = await tagClient.update(tag.id, tagAttributes);
      onSave(createdTag);
    } catch (e) {
      // if e is IHttpFetchError, actual server error payload is in e.body
      if ((0, _tags.isServerValidationError)(e.body)) {
        setValidation(e.body.attributes);
      }
    }
  }, [tagAttributes, tagClient, onSave, tag]);
  return /*#__PURE__*/_react.default.createElement(_create_or_edit_modal.CreateOrEditModal, {
    onClose: onClose,
    onSubmit: onSubmit,
    mode: 'edit',
    tag: tagAttributes,
    setField: setField,
    validation: validation
  });
};
exports.EditTagModal = EditTagModal;