"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectedTagListComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _utils = require("../../utils");
var _base = require("../base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedObjectTagList = ({
  object,
  tags: allTags,
  onClick,
  tagRender
}) => {
  const objectTags = (0, _react.useMemo)(() => {
    const {
      tags
    } = (0, _utils.getObjectTags)(object, allTags);
    tags.sort(_utils.byNameTagSorter);
    return tags;
  }, [object, allTags]);
  return /*#__PURE__*/_react.default.createElement(_base.TagList, {
    tags: objectTags,
    onClick: onClick,
    tagRender: tagRender
  });
};
const getConnectedTagListComponent = ({
  cache
}) => {
  return props => {
    const tags = (0, _useObservable.default)(cache.getState$(), cache.getState());
    return /*#__PURE__*/_react.default.createElement(SavedObjectTagList, (0, _extends2.default)({}, props, {
      tags: tags
    }));
  };
};
exports.getConnectedTagListComponent = getConnectedTagListComponent;