"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseQuery = parseQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseQuery(query) {
  let queryText;
  let selectedTypes;
  if (query) {
    if (query.ast.getTermClauses().length) {
      queryText = query.ast.getTermClauses().map(clause => clause.value).join(' ');
    }
    if (query.ast.getFieldClauses('type')) {
      selectedTypes = query.ast.getFieldClauses('type')[0].value;
    }
  }
  return {
    queryText,
    selectedTypes
  };
}