"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectTagReferences = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Inject the tags back into the object's references
 *
 * (`injectReferences`) is used when fetching the object from the backend
 */
const injectTagReferences = (object, references = []) => {
  object.__tags = references.filter(({
    type
  }) => type === 'tag').map(({
    id
  }) => id);
};
exports.injectTagReferences = injectTagReferences;