"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decorateObject = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Enhance the object with tag accessors
 */
const decorateObject = object => {
  object.getTags = () => {
    var _object$__tags;
    return (_object$__tags = object.__tags) !== null && _object$__tags !== void 0 ? _object$__tags : [];
  };
  object.setTags = tagIds => {
    object.__tags = tagIds;
  };
};
exports.decorateObject = decorateObject;