"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectDecoratorRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedObjectDecoratorRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", new Map());
  }
  register(config) {
    if (this.registry.has(config.id)) {
      throw new Error(`A decorator is already registered for id ${config.id}`);
    }
    if ([...this.registry.values()].find(({
      priority
    }) => priority === config.priority)) {
      throw new Error(`A decorator is already registered for priority ${config.priority}`);
    }
    this.registry.set(config.id, config);
  }
  getOrderedDecorators(services) {
    return [...this.registry.values()].sort((a, b) => a.priority - b.priority).map(({
      factory
    }) => factory(services));
  }
}
exports.SavedObjectDecoratorRegistry = SavedObjectDecoratorRegistry;