"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectSaveModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const generateId = (0, _eui.htmlIdGenerator)();

/**
 * @deprecated
 * @removeBy 8.8.0
 */
class SavedObjectSaveModal extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "warning", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "formId", generateId('form'));
    (0, _defineProperty2.default)(this, "state", {
      title: this.props.title,
      copyOnSave: Boolean(this.props.initialCopyOnSave),
      isTitleDuplicateConfirmed: false,
      hasTitleDuplicate: false,
      isLoading: false,
      visualizationDescription: this.props.description ? this.props.description : ''
    });
    (0, _defineProperty2.default)(this, "renderViewDescription", () => {
      if (!this.props.showDescription) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.descriptionLabel",
          defaultMessage: "Description"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        "data-test-subj": "viewDescription",
        value: this.state.visualizationDescription,
        onChange: this.onDescriptionChange
      }));
    });
    (0, _defineProperty2.default)(this, "onDescriptionChange", event => {
      this.setState({
        visualizationDescription: event.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onTitleDuplicate", () => {
      this.setState({
        isLoading: false,
        isTitleDuplicateConfirmed: true,
        hasTitleDuplicate: true
      });
      if (this.warning.current) {
        this.warning.current.focus();
      }
    });
    (0, _defineProperty2.default)(this, "saveSavedObject", async () => {
      if (this.state.isLoading) {
        // ignore extra clicks
        return;
      }
      this.setState({
        isLoading: true
      });
      await this.props.onSave({
        newTitle: this.state.title,
        newCopyOnSave: this.state.copyOnSave,
        isTitleDuplicateConfirmed: this.state.isTitleDuplicateConfirmed,
        onTitleDuplicate: this.onTitleDuplicate,
        newDescription: this.state.visualizationDescription
      });
    });
    (0, _defineProperty2.default)(this, "onTitleChange", event => {
      this.setState({
        title: event.target.value,
        isTitleDuplicateConfirmed: false,
        hasTitleDuplicate: false
      });
    });
    (0, _defineProperty2.default)(this, "onCopyOnSaveChange", event => {
      this.setState({
        copyOnSave: event.target.checked
      });
      if (this.props.onCopyOnSaveChange) {
        this.props.onCopyOnSaveChange(event.target.checked);
      }
    });
    (0, _defineProperty2.default)(this, "onFormSubmit", event => {
      event.preventDefault();
      this.saveSavedObject();
    });
    (0, _defineProperty2.default)(this, "renderConfirmButton", () => {
      const {
        isLoading,
        title
      } = this.state;
      let confirmLabel = _i18n.i18n.translate('savedObjects.saveModal.saveButtonLabel', {
        defaultMessage: 'Save'
      });
      if (this.props.confirmButtonLabel) {
        confirmLabel = this.props.confirmButtonLabel;
      }
      const isValid = this.props.isValid !== undefined ? this.props.isValid : true;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "confirmSaveSavedObjectButton",
        isLoading: isLoading,
        isDisabled: title.length === 0 || !isValid,
        type: "submit",
        form: this.formId
      }, confirmLabel);
    });
    (0, _defineProperty2.default)(this, "renderDuplicateTitleCallout", duplicateWarningId => {
      if (!this.state.hasTitleDuplicate) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        ref: this.warning,
        tabIndex: -1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.duplicateTitleLabel",
          defaultMessage: "This {objectType} already exists",
          values: {
            objectType: this.props.objectType
          }
        }),
        color: "warning",
        "data-test-subj": "titleDupicateWarnMsg",
        id: duplicateWarningId
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.duplicateTitleDescription",
        defaultMessage: "Saving '{title}' creates a duplicate title.",
        values: {
          title: this.state.title
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
    });
    (0, _defineProperty2.default)(this, "renderCopyOnSave", () => {
      if (!this.props.showCopyOnSave) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "saveAsNewCheckbox",
        checked: this.state.copyOnSave,
        onChange: this.onCopyOnSaveChange,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.saveAsNewLabel",
          defaultMessage: "Save as new {objectType}",
          values: {
            objectType: this.props.objectType
          }
        })
      }));
    });
  }
  render() {
    const {
      isTitleDuplicateConfirmed,
      hasTitleDuplicate,
      title
    } = this.state;
    const duplicateWarningId = generateId();
    const hasColumns = !!this.props.rightOptions;
    const formBodyContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.titleLabel",
        defaultMessage: "Title"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      autoFocus: true,
      "data-test-subj": "savedObjectTitle",
      value: title,
      onChange: this.onTitleChange,
      isInvalid: !isTitleDuplicateConfirmed && hasTitleDuplicate || title.length === 0,
      "aria-describedby": this.state.hasTitleDuplicate ? duplicateWarningId : undefined
    })), this.renderViewDescription(), typeof this.props.options === 'function' ? this.props.options(this.state) : this.props.options);
    const formBody = hasColumns ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, formBodyContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, typeof this.props.rightOptions === 'function' ? this.props.rightOptions(this.state) : this.props.rightOptions)) : formBodyContent;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "savedObjectSaveModal",
      className: `kbnSavedObjectSaveModal${hasColumns ? ' kbnSavedObjectsSaveModal--wide' : ''}`,
      onClose: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.saveTitle",
      defaultMessage: "Save {objectType}",
      values: {
        objectType: this.props.objectType
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, this.renderDuplicateTitleCallout(duplicateWarningId), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      onSubmit: this.onFormSubmit,
      id: this.formId
    }, !this.props.showDescription && this.props.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, this.props.description), formBody, this.renderCopyOnSave())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "saveCancelButton",
      onClick: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), this.renderConfirmButton()));
  }
}
exports.SavedObjectSaveModal = SavedObjectSaveModal;