"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareToSpaceSavedObjectsManagementAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Wrapper = ({
  spacesApiUi,
  props
}) => {
  const LazyComponent = (0, _react.useMemo)(() => spacesApiUi.components.getShareToSpaceFlyout, [spacesApiUi]);
  return /*#__PURE__*/_react.default.createElement(LazyComponent, props);
};
class ShareToSpaceSavedObjectsManagementAction extends _types.SavedObjectsManagementAction {
  constructor(spacesApiUi) {
    super();
    (0, _defineProperty2.default)(this, "id", 'share_saved_objects_to_space');
    (0, _defineProperty2.default)(this, "euiAction", {
      name: _i18n.i18n.translate('savedObjectsManagement.shareToSpace.actionTitle', {
        defaultMessage: 'Share to spaces'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.shareToSpace.actionDescription', {
        defaultMessage: 'Share this object to one or more spaces'
      }),
      icon: 'share',
      type: 'icon',
      available: object => {
        const hasCapability = !this.actionContext || !!this.actionContext.capabilities.savedObjectsManagement.shareIntoSpace;
        const {
          namespaceType,
          hiddenType
        } = object.meta;
        return namespaceType === 'multiple' && !hiddenType && hasCapability;
      },
      onClick: object => {
        this.objectsToRefresh = [];
        this.start(object);
      }
    });
    (0, _defineProperty2.default)(this, "refreshOnFinish", () => this.objectsToRefresh);
    (0, _defineProperty2.default)(this, "objectsToRefresh", []);
    (0, _defineProperty2.default)(this, "render", () => {
      var _this$record$namespac;
      if (!this.record) {
        throw new Error('No record available! `render()` was likely called before `start()`.');
      }
      const props = {
        savedObjectTarget: {
          type: this.record.type,
          id: this.record.id,
          namespaces: (_this$record$namespac = this.record.namespaces) !== null && _this$record$namespac !== void 0 ? _this$record$namespac : [],
          title: this.record.meta.title,
          icon: this.record.meta.icon
        },
        flyoutIcon: 'share',
        onUpdate: updatedObjects => this.objectsToRefresh = [...updatedObjects],
        onClose: this.onClose,
        enableCreateCopyCallout: true,
        enableCreateNewSpaceLink: true
      };
      return /*#__PURE__*/_react.default.createElement(Wrapper, {
        spacesApiUi: this.spacesApiUi,
        props: props
      });
    });
    (0, _defineProperty2.default)(this, "onClose", () => {
      this.finish();
    });
    this.spacesApiUi = spacesApiUi;
  }
}
exports.ShareToSpaceSavedObjectsManagementAction = ShareToSpaceSavedObjectsManagementAction;