"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _objects_table = require("./objects_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const SavedObjectsTablePage = ({
  coreStart,
  dataStart,
  dataViewsApi,
  taggingApi,
  spacesApi,
  allowedTypes,
  actionRegistry,
  columnRegistry,
  setBreadcrumbs
}) => {
  const capabilities = coreStart.application.capabilities;
  const itemsPerPage = coreStart.uiSettings.get('savedObjects:perPage', 50);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const initialQuery = (0, _react.useMemo)(() => {
    const query = (0, _queryString.parse)(search);
    try {
      var _ref;
      return _eui.Query.parse((_ref = query.initialQuery) !== null && _ref !== void 0 ? _ref : '');
    } catch (e) {
      return _eui.Query.parse('');
    }
  }, [search]);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('savedObjectsManagement.breadcrumb.index', {
        defaultMessage: 'Saved objects'
      })
    }]);
  }, [setBreadcrumbs]);
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, null, /*#__PURE__*/_react.default.createElement(_objects_table.SavedObjectsTable, {
    initialQuery: initialQuery,
    allowedTypes: allowedTypes,
    actionRegistry: actionRegistry,
    columnRegistry: columnRegistry,
    taggingApi: taggingApi,
    dataViews: dataViewsApi,
    search: dataStart.search,
    http: coreStart.http,
    overlays: coreStart.overlays,
    notifications: coreStart.notifications,
    applications: coreStart.application,
    perPageConfig: itemsPerPage,
    goInspectObject: savedObject => {
      const savedObjectEditUrl = savedObject.meta.editUrl ? `/app${savedObject.meta.editUrl}` : `/app/management/kibana/objects/${savedObject.type}/${savedObject.id}`;
      coreStart.application.navigateToUrl(coreStart.http.basePath.prepend(savedObjectEditUrl));
    },
    canGoInApp: savedObject => {
      const {
        inAppUrl
      } = savedObject.meta;
      if (!inAppUrl) return false;
      if (!inAppUrl.uiCapabilitiesPath) return true;
      return Boolean((0, _lodash.get)(capabilities, inAppUrl.uiCapabilitiesPath));
    },
    customBranding: coreStart.customBranding
  }));
};
// eslint-disable-next-line import/no-default-export
exports.default = SavedObjectsTablePage;
module.exports = exports.default;