"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Header = ({
  onExportAll,
  onImport,
  onRefresh,
  filteredCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.savedObjectsTitle",
    defaultMessage: "Saved Objects"
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.howToDeleteSavedObjectsDescription",
    defaultMessage: "Manage and share your saved objects. To edit the underlying data of an object, go to its associated application."
  }),
  bottomBorder: true,
  rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "exportAction",
    "data-test-subj": "exportAllObjects",
    onClick: onExportAll
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.exportButtonLabel",
    defaultMessage: "Export {filteredCount, plural, one{# object} other {# objects}}",
    values: {
      filteredCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "importAction",
    "data-test-subj": "importObjects",
    onClick: onImport
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.importButtonLabel",
    defaultMessage: "Import"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "refresh",
    onClick: onRefresh
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.refreshButtonLabel",
    defaultMessage: "Refresh"
  }))]
});
exports.Header = Header;