"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../../../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeleteConfirmModal = ({
  isDeleting,
  onConfirm,
  onCancel,
  selectedObjects,
  allowedTypes,
  showPlainSpinner
}) => {
  const undeletableObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => obj.meta.hiddenType);
  }, [selectedObjects]);
  const deletableObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => !obj.meta.hiddenType).map(({
      type,
      id,
      meta,
      namespaces = []
    }) => {
      const {
        title = '',
        icon = 'apps'
      } = meta;
      const isShared = namespaces.length > 1 || namespaces.includes('*');
      return {
        type,
        id,
        icon,
        title,
        isShared
      };
    });
  }, [selectedObjects]);
  const sharedObjectsCount = (0, _react.useMemo)(() => {
    return deletableObjects.filter(obj => obj.isShared).length;
  }, [deletableObjects]);
  if (isDeleting) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xl"
    }));
  }
  // can't use `EuiConfirmModal` here as the confirm modal body is wrapped
  // inside a `<p>` element, causing UI glitches with the table.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "soDeleteConfirmModalConfirmBtn",
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModalTitle",
    defaultMessage: "Delete saved objects"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, undeletableObjects.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "cannotDeleteObjectsConfirmWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.title",
      defaultMessage: "Some objects cannot be deleted"
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.content",
    defaultMessage: "{objectCount, plural, one {# object is} other {# objects are}} hidden and cannot be deleted. {objectCount, plural, one {It was} other {They were}} excluded from the table summary.",
    values: {
      objectCount: undeletableObjects.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), sharedObjectsCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "sharedObjectsWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.title",
      defaultMessage: "{sharedObjectsCount, plural, one {# saved object is shared} other {# of your saved objects are shared}}",
      values: {
        sharedObjectsCount
      }
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.content",
    defaultMessage: "Shared objects are deleted from every space they are in."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.deleteSavedObjectsConfirmModalDescription",
    defaultMessage: "This action will delete the following saved objects:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: deletableObjects,
    columns: [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.typeColumnName', {
        defaultMessage: 'Type'
      }),
      width: '50px',
      render: (type, {
        icon
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: (0, _lib.getSavedObjectLabel)(type, allowedTypes)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon
      }))
    }, {
      field: 'id',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.idColumnName', {
        defaultMessage: 'Id'
      })
    }, {
      field: 'title',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.titleColumnName', {
        defaultMessage: 'Title'
      })
    }],
    pagination: true,
    sorting: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "confirmModalCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: "soDeleteConfirmModalConfirmBtn",
    fill: true,
    color: "danger",
    onClick: onConfirm,
    disabled: deletableObjects.length === 0,
    "data-test-subj": "confirmModalConfirmButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.deleteButtonLabel",
    defaultMessage: "Delete {objectsCount, plural, one {# object} other {# objects}}",
    values: {
      objectsCount: deletableObjects.length
    }
  }))))))));
};
exports.DeleteConfirmModal = DeleteConfirmModal;