"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFindRoute = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerFindRoute = router => {
  router.get({
    path: '/internal/saved-objects-finder/find',
    validate: {
      query: _configSchema.schema.object({
        perPage: _configSchema.schema.number({
          min: 0,
          defaultValue: 20
        }),
        page: _configSchema.schema.number({
          min: 0,
          defaultValue: 1
        }),
        type: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        defaultSearchOperator: _configSchema.schema.oneOf([_configSchema.schema.literal('AND'), _configSchema.schema.literal('OR')]),
        sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
        fields: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())], {
          defaultValue: []
        }),
        searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
        hasReference: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    },
    options: {
      authRequired: 'optional'
    }
  }, async (ctx, req, res) => {
    const savedObjectsClient = (await ctx.core).savedObjects.client;
    const {
      query
    } = req;
    const searchTypes = Array.isArray(query.type) ? query.type : [query.type];
    const includedFields = Array.isArray(query.fields) ? query.fields : [query.fields];
    const findResponse = await savedObjectsClient.find({
      ...query,
      type: searchTypes,
      fields: includedFields,
      hasReference: query.hasReference ? JSON.parse(query.hasReference) : undefined
    });
    const savedObjects = findResponse.saved_objects;
    const response = {
      saved_objects: savedObjects,
      total: findResponse.total,
      per_page: findResponse.per_page,
      page: findResponse.page
    };
    return res.ok({
      body: response
    });
  });
};
exports.registerFindRoute = registerFindRoute;