"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuntimeFieldEditorLoader = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("./shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getRuntimeFieldEditorLoader = coreSetup => async () => {
  const {
    RuntimeFieldEditorFlyoutContent
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components')));
  const [core] = await coreSetup.getStartServices();
  const {
    uiSettings,
    theme,
    overlays,
    docLinks
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings
  });
  let overlayRef = null;
  const openEditor = ({
    onSave,
    defaultValue,
    ctx
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveField = field => {
      closeEditor();
      onSave(field);
    };
    overlayRef = overlays.openFlyout((0, _shared_imports.toMountPoint)( /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(RuntimeFieldEditorFlyoutContent, {
      onSave: onSaveField,
      onCancel: () => {
        var _overlayRef;
        return (_overlayRef = overlayRef) === null || _overlayRef === void 0 ? void 0 : _overlayRef.close();
      },
      docLinks: docLinks,
      defaultValue: defaultValue,
      ctx: ctx
    })), {
      theme$: theme.theme$
    }));
    return closeEditor;
  };
  return {
    openEditor
  };
};
exports.getRuntimeFieldEditorLoader = getRuntimeFieldEditorLoader;