"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpdatedFlappingHistory = getUpdatedFlappingHistory;
var _lib = require("@kbn/alerting-plugin/server/lib");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUpdatedFlappingHistory(flappingSettings, alertId, state, isNew, isRecovered, isActive, recoveredIds) {
  // duplicating this logic to determine flapping at this level
  let flappingHistory = [];
  if (flappingSettings.enabled) {
    if (isRecovered) {
      if (state.trackedAlerts[alertId]) {
        // this alert has flapped from active to recovered
        flappingHistory = (0, _lib.updateFlappingHistory)(flappingSettings, state.trackedAlerts[alertId].flappingHistory, true);
      } else if (state.trackedAlertsRecovered[alertId]) {
        // this alert is still recovered
        flappingHistory = (0, _lib.updateFlappingHistory)(flappingSettings, state.trackedAlertsRecovered[alertId].flappingHistory, false);
      }
    } else if (isNew) {
      if (state.trackedAlertsRecovered[alertId]) {
        // this alert has flapped from recovered to active
        flappingHistory = (0, _lib.updateFlappingHistory)(flappingSettings, state.trackedAlertsRecovered[alertId].flappingHistory, true);
        (0, _lodash.remove)(recoveredIds, id => id === alertId);
      } else {
        flappingHistory = (0, _lib.updateFlappingHistory)(flappingSettings, [], true);
      }
    } else if (isActive) {
      // this alert is still active
      flappingHistory = (0, _lib.updateFlappingHistory)(flappingSettings, state.trackedAlerts[alertId].flappingHistory, false);
    }
  }
  return flappingHistory;
}