"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertSummaryRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../common/constants");
var _route_validation = require("./utils/route_validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertSummaryRoute = router => {
  router.post({
    path: `${_constants.BASE_RAC_ALERTS_API_PATH}/_alert_summary`,
    validate: {
      body: (0, _route_validation.buildRouteValidation)(t.intersection([t.exact(t.type({
        gte: t.string,
        lte: t.string,
        featureIds: t.array(t.string)
      })), t.exact(t.partial({
        fixed_interval: t.string,
        filter: t.array(t.object)
      }))]))
    },
    options: {
      tags: ['access:rac']
    }
  }, async (context, request, response) => {
    try {
      const racContext = await context.rac;
      const alertsClient = await racContext.getAlertsClient();
      const {
        gte,
        lte,
        featureIds,
        filter,
        fixed_interval: fixedInterval
      } = request.body;
      if (!((0, _moment.default)(gte, 'YYYY-MM-DDTHH:mm:ss.SSSZ', true).isValid() && (0, _moment.default)(lte, 'YYYY-MM-DDTHH:mm:ss.SSSZ', true).isValid())) {
        throw _boom.default.badRequest('gte and/or lte are not following the UTC format');
      }
      if (fixedInterval && (fixedInterval === null || fixedInterval === void 0 ? void 0 : fixedInterval.match(/^\d{1,6}['s','m','h','d']$/)) == null) {
        throw _boom.default.badRequest(`fixed_interval (value: ${fixedInterval}) is not following the expected format 1s, 1m, 1h, 1d with at most 6 digits`);
      }
      const aggs = await alertsClient.getAlertSummary({
        gte,
        lte,
        featureIds,
        filter: filter,
        fixedInterval
      });
      return response.ok({
        body: aggs
      });
    } catch (exc) {
      const err = (0, _securitysolutionEsUtils.transformError)(exc);
      const contentType = {
        'content-type': 'application/json'
      };
      const defaultedHeaders = {
        ...contentType
      };
      return response.customError({
        headers: defaultedHeaders,
        statusCode: err.statusCode,
        body: {
          message: err.message,
          attributes: {
            success: false
          }
        }
      });
    }
  });
};
exports.getAlertSummaryRoute = getAlertSummaryRoute;