"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rollupToggleExtension = exports.rollupBadgeExtension = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const propertyPath = 'isRollupIndex';
const rollupToggleExtension = {
  matchIndex: index => {
    return (0, _lodash.get)(index, propertyPath);
  },
  label: _i18n.i18n.translate('xpack.rollupJobs.indexMgmtToggle.toggleLabel', {
    defaultMessage: 'Include rollup indices'
  }),
  name: 'rollupToggle'
};
exports.rollupToggleExtension = rollupToggleExtension;
const rollupBadgeExtension = {
  matchIndex: index => {
    return (0, _lodash.get)(index, propertyPath);
  },
  label: _i18n.i18n.translate('xpack.rollupJobs.indexMgmtBadge.rollupLabel', {
    defaultMessage: 'Rollup'
  }),
  color: 'success',
  filterExpression: 'isRollupIndex:true'
};
exports.rollupBadgeExtension = rollupBadgeExtension;