"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharedComponents = getSharedComponents;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../common/constants");
var _screen_capture_panel_content_lazy = require("../share_context_menu/screen_capture_panel_content_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * As of 7.14, the only shared component is a PDF report that is suited for Canvas integration.
 * This is not planned to expand, as work is to be done on moving the export-type implementations out of Reporting
 * Related Discuss issue: https://github.com/elastic/kibana/issues/101422
 */
function getSharedComponents(core, apiClient) {
  return {
    ReportingPanelPDF(props) {
      return /*#__PURE__*/_react.default.createElement(_screen_capture_panel_content_lazy.ScreenCapturePanelContent, (0, _extends2.default)({
        requiresSavedState: false,
        reportType: _constants.PDF_REPORT_TYPE,
        apiClient: apiClient,
        toasts: core.notifications.toasts,
        uiSettings: core.uiSettings,
        theme: core.theme
      }, props));
    },
    ReportingPanelPDFV2(props) {
      return /*#__PURE__*/_react.default.createElement(_screen_capture_panel_content_lazy.ScreenCapturePanelContent, (0, _extends2.default)({
        requiresSavedState: false,
        reportType: _constants.PDF_REPORT_TYPE_V2,
        apiClient: apiClient,
        toasts: core.notifications.toasts,
        uiSettings: core.uiSettings,
        theme: core.theme
      }, props));
    },
    ReportingPanelPNGV2(props) {
      return /*#__PURE__*/_react.default.createElement(_screen_capture_panel_content_lazy.ScreenCapturePanelContent, (0, _extends2.default)({
        requiresSavedState: false,
        reportType: _constants.PNG_REPORT_TYPE_V2,
        apiClient: apiClient,
        toasts: core.notifications.toasts,
        uiSettings: core.uiSettings,
        theme: core.theme
      }, props));
    }
  };
}