"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorUrlTooLongPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  title: _i18n.i18n.translate('xpack.reporting.panelContent.unsavedStateAndExceedsMaxLengthTitle', {
    defaultMessage: 'URL too long'
  })
};
const ErrorUrlTooLongPanel = ({
  isUnsaved
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: i18nTexts.title,
  size: "s",
  iconType: "warning",
  color: "danger"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, isUnsaved ? /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "urlTooLongTrySavingMessage"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.reporting.panelContent.unsavedStateAndExceedsMaxLengthTrySaveDescription",
  defaultMessage: "This URL cannot be copied. Try saving your work."
})) :
/*#__PURE__*/
// Reaching this state is essentially just an error and should result in a user contacting us.
_react.default.createElement("span", {
  "data-test-subj": "urlTooLongErrorMessage"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.reporting.panelContent.unsavedStateAndExceedsMaxLengthDescription",
  defaultMessage: "This URL cannot be copied."
})))));
exports.ErrorUrlTooLongPanel = ErrorUrlTooLongPanel;