"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.remove = exports.add = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const set = jobs => {
  sessionStorage.setItem(_constants.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY, JSON.stringify(jobs));
};
const getAll = () => {
  const sessionValue = sessionStorage.getItem(_constants.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY);
  return sessionValue ? JSON.parse(sessionValue) : [];
};
const add = jobId => {
  const jobs = getAll();
  jobs.push(jobId);
  set(jobs);
};
exports.add = add;
const remove = jobId => {
  const jobs = getAll();
  const index = jobs.indexOf(jobId);
  if (!index) {
    throw new Error('Unable to find job to remove it');
  }
  jobs.splice(index, 1);
  set(jobs);
};
exports.remove = remove;