"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDiagnostic = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var statuses;
(function (statuses) {
  statuses["chromeStatus"] = "chromeStatus";
  statuses["screenshotStatus"] = "screenshotStatus";
})(statuses || (statuses = {}));
const initialState = {
  [statuses.chromeStatus]: 'incomplete',
  [statuses.screenshotStatus]: 'incomplete',
  isFlyoutVisible: false,
  help: [],
  logs: '',
  isBusy: false,
  success: true
};
const ReportDiagnostic = ({
  apiClient
}) => {
  const [state, setStateBase] = (0, _react.useState)(initialState);
  const setState = s => setStateBase({
    ...state,
    ...s
  });
  const {
    isBusy,
    screenshotStatus,
    chromeStatus,
    isFlyoutVisible,
    help,
    logs,
    success
  } = state;
  const closeFlyout = () => setState({
    ...initialState,
    isFlyoutVisible: false
  });
  const showFlyout = () => setState({
    isFlyoutVisible: true
  });
  const apiWrapper = (apiMethod, statusProp) => () => {
    setState({
      isBusy: true,
      [statusProp]: 'incomplete'
    });
    apiMethod().then(response => {
      setState({
        isBusy: false,
        help: response.help,
        logs: response.logs,
        success: response.success,
        [statusProp]: response.success ? 'complete' : 'danger'
      });
    }).catch(error => {
      setState({
        isBusy: false,
        help: [_i18n.i18n.translate('xpack.reporting.listing.diagnosticApiCallFailure', {
          defaultMessage: `There was a problem running the diagnostic: {error}`,
          values: {
            error
          }
        })],
        logs: `${error.message}`,
        success: false,
        [statusProp]: 'danger'
      });
    });
  };
  const steps = [{
    title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticBrowserTitle', {
      defaultMessage: 'Check browser'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticBrowserMessage",
      defaultMessage: "Reporting uses a headless browser to generate PDF and PNGs. Validate that the browser can launch successfully."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: isBusy || chromeStatus === 'complete',
      onClick: apiWrapper(() => apiClient.verifyBrowser(), statuses.chromeStatus),
      isLoading: isBusy && chromeStatus === 'incomplete',
      iconType: chromeStatus === 'complete' ? 'check' : undefined
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticBrowserButton",
      defaultMessage: "Check browser"
    }))),
    status: !success && chromeStatus !== 'complete' ? 'danger' : chromeStatus
  }];
  if (chromeStatus === 'complete') {
    steps.push({
      title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticScreenshotTitle', {
        defaultMessage: 'Check screen capture'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.reporting.listing.diagnosticScreenshotMessage",
        defaultMessage: "Ensure that the headless browser can capture a screenshot of a page."
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: isBusy || screenshotStatus === 'complete',
        onClick: apiWrapper(() => apiClient.verifyScreenCapture(), statuses.screenshotStatus),
        isLoading: isBusy && screenshotStatus === 'incomplete',
        iconType: screenshotStatus === 'complete' ? 'check' : undefined
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.reporting.listing.diagnosticScreenshotButton",
        defaultMessage: "Capture screenshot"
      }))),
      status: !success && screenshotStatus !== 'complete' ? 'danger' : screenshotStatus
    });
  }
  if (screenshotStatus === 'complete') {
    steps.push({
      title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticSuccessTitle', {
        defaultMessage: 'All set!'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.reporting.listing.diagnosticSuccessMessage",
        defaultMessage: "Everything looks good for reporting to function."
      })),
      status: !success ? 'danger' : screenshotStatus
    });
  }
  if (!success) {
    steps.push({
      title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticFailureTitle', {
        defaultMessage: "Something isn't working properly."
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, help.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        iconType: "warning"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, help.join('\n'))))) : null, logs.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.reporting.listing.diagnosticFailureDescription",
        defaultMessage: "Here are some details about the issue:"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, logs)) : null),
      status: 'danger'
    });
  }
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: closeFlyout,
      "aria-labelledby": "reportingHelperTitle",
      size: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticTitle",
      defaultMessage: "Reporting Diagnostics"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticDescription",
      defaultMessage: "Run diagnostics to automatically troubleshoot common reporting problems."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
      steps: steps
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, flyout, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    onClick: showFlyout
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.listing.diagnosticButton",
    defaultMessage: "Run reporting diagnostics"
  })));
};
exports.ReportDiagnostic = ReportDiagnostic;