"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkLicense = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkLicense = checkResults => {
  switch (checkResults.state) {
    case 'valid':
      {
        return {
          showLinks: true,
          enableLinks: true,
          message: ''
        };
      }
    case 'invalid':
      {
        return {
          showLinks: false,
          enableLinks: false,
          message: 'Your license does not support Reporting. Please upgrade your license.'
        };
      }
    case 'unavailable':
      {
        return {
          showLinks: true,
          enableLinks: false,
          message: 'You cannot use Reporting because license information is not available at this time.'
        };
      }
    case 'expired':
      {
        return {
          showLinks: true,
          enableLinks: false,
          message: 'You cannot use Reporting because your license has expired.'
        };
      }
    default:
      {
        return {
          showLinks: true,
          enableLinks: true,
          message: ''
        };
      }
  }
};
exports.checkLicense = checkLicense;