"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIlmPolicyStatus = exports.IlmPolicyStatusContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reporting_api_client = require("./reporting_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IlmPolicyStatusContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const IlmPolicyStatusContextProvider = ({
  children
}) => {
  const {
    isLoading,
    data,
    resendRequest: recheckStatus
  } = (0, _reporting_api_client.useCheckIlmPolicyStatus)();
  return /*#__PURE__*/_react.default.createElement(IlmPolicyStatusContext.Provider, {
    value: {
      isLoading,
      status: data === null || data === void 0 ? void 0 : data.status,
      recheckStatus
    }
  }, children);
};
exports.IlmPolicyStatusContextProvider = IlmPolicyStatusContextProvider;
const useIlmPolicyStatus = () => {
  const ctx = (0, _react.useContext)(IlmPolicyStatusContext);
  if (!ctx) {
    throw new Error('"useIlmPolicyStatus" can only be used inside of "IlmPolicyStatusContext"');
  }
  return ctx;
};
exports.useIlmPolicyStatus = useIlmPolicyStatus;