"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRemovingCluster = exports.isLoading = exports.isEditingCluster = exports.isDetailPanelOpen = exports.isAddingCluster = exports.getEditedCluster = exports.getEditClusterError = exports.getDetailPanelClusterName = exports.getDetailPanelCluster = exports.getClustersList = exports.getClustersByName = exports.getClusterByName = exports.getAddClusterError = exports.clusterLoadError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getClustersList = state => state.clusters.asList;
exports.getClustersList = getClustersList;
const getClustersByName = state => state.clusters.byName;
exports.getClustersByName = getClustersByName;
const getClusterByName = (state, name) => getClustersByName(state)[name];
exports.getClusterByName = getClusterByName;
const isDetailPanelOpen = state => state.detailPanel.isOpen;
exports.isDetailPanelOpen = isDetailPanelOpen;
const getDetailPanelCluster = state => getClusterByName(state, state.detailPanel.clusterName);
exports.getDetailPanelCluster = getDetailPanelCluster;
const getDetailPanelClusterName = state => state.detailPanel.clusterName;
exports.getDetailPanelClusterName = getDetailPanelClusterName;
const isLoading = state => state.clusters.isLoading;
exports.isLoading = isLoading;
const clusterLoadError = state => state.clusters.clusterLoadError;
exports.clusterLoadError = clusterLoadError;
const isAddingCluster = state => state.addCluster.isAdding;
exports.isAddingCluster = isAddingCluster;
const getAddClusterError = state => state.addCluster.error;
exports.getAddClusterError = getAddClusterError;
const getEditedCluster = state => getClustersByName(state)[state.editCluster.clusterName];
exports.getEditedCluster = getEditedCluster;
const isEditingCluster = state => state.editCluster.isEditing;
exports.isEditingCluster = isEditingCluster;
const getEditClusterError = state => state.editCluster.error;
exports.getEditClusterError = getEditClusterError;
const isRemovingCluster = state => state.removeCluster.isRemoving;
exports.isRemovingCluster = isRemovingCluster;