"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.refreshClusters = void 0;
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const refreshClusters = () => async dispatch => {
  let clusters;
  try {
    clusters = await (0, _services.loadClusters)({
      asSystemRequest: true
    });
  } catch (error) {
    return (0, _services.showApiWarning)(error, _i18n.i18n.translate('xpack.remoteClusters.refreshAction.errorTitle', {
      defaultMessage: 'Error refreshing remote clusters'
    }));
  }
  dispatch({
    type: _action_types.REFRESH_CLUSTERS_SUCCESS,
    payload: {
      clusters
    }
  });
};
exports.refreshClusters = refreshClusters;