"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _reactRedux = require("react-redux");
var _detail_panel = require("./detail_panel");
var _selectors = require("../../../store/selectors");
var _actions = require("../../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isOpen: (0, _selectors.isDetailPanelOpen)(state),
    isLoading: (0, _selectors.isLoading)(state),
    cluster: (0, _selectors.getDetailPanelCluster)(state),
    clusterName: (0, _selectors.getDetailPanelClusterName)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    closeDetailPanel: () => {
      dispatch((0, _actions.closeDetailPanel)());
    }
  };
};
const DetailPanel = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_detail_panel.DetailPanel);
exports.DetailPanel = DetailPanel;