"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionStatus = ConnectionStatus;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConnectionStatus({
  isConnected,
  mode
}) {
  let icon;
  let message;
  if (isConnected) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: "success"
    });
    message = _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.connectedAriaLabel', {
      defaultMessage: 'Connected'
    });
  } else {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      color: "danger"
    });
    message = _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedAriaLabel', {
      defaultMessage: 'Not connected'
    });
  }
  const seedNodeTooltip = _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedToolTip', {
    defaultMessage: `Ensure the seed nodes are configured with the remote cluster's transport port, not the http port.`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "remoteClusterConnectionStatusIcon",
    className: "eui-displayBlock"
  }, icon)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "remoteClustersConnectionStatus__message"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "remoteClusterConnectionStatusMessage",
    size: "s"
  }, message)), !isConnected && mode === _constants.SNIFF_MODE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: seedNodeTooltip
  })));
}
ConnectionStatus.propTypes = {
  isConnected: _propTypes.default.bool,
  mode: _propTypes.default.oneOf([_constants.SNIFF_MODE, _constants.PROXY_MODE])
};