"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterAdd = void 0;
var _reactRedux = require("react-redux");
var _remote_cluster_add = require("./remote_cluster_add");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isAddingCluster: (0, _selectors.isAddingCluster)(state),
    addClusterError: (0, _selectors.getAddClusterError)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    addCluster: cluster => {
      dispatch((0, _actions.addCluster)(cluster));
    },
    clearAddClusterErrors: () => {
      dispatch((0, _actions.clearAddClusterErrors)());
    }
  };
};
const RemoteClusterAdd = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_remote_cluster_add.RemoteClusterAdd);
exports.RemoteClusterAdd = RemoteClusterAdd;