"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCloudUrl = exports.isCloudUrlEnabled = exports.i18nTexts = exports.convertProxyConnectionToCloudUrl = exports.convertCloudUrlToProxyConnection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _validate_address = require("./validate_address");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  urlEmpty: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.urlRequiredError",
    defaultMessage: "A url is required."
  }),
  urlInvalid: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.urlInvalidError",
    defaultMessage: "Url is invalid"
  })
};
exports.i18nTexts = i18nTexts;
const CLOUD_DEFAULT_PROXY_PORT = '9400';
const EMPTY_PROXY_VALUES = {
  proxyAddress: '',
  serverName: ''
};
const PROTOCOL_REGEX = new RegExp(/^https?:\/\//);
const isCloudUrlEnabled = cluster => {
  // enable cloud url for new clusters
  if (!cluster) {
    return true;
  }
  const {
    proxyAddress,
    serverName
  } = cluster;
  if (!proxyAddress && !serverName) {
    return true;
  }
  const portParts = (proxyAddress !== null && proxyAddress !== void 0 ? proxyAddress : '').split(':');
  const proxyAddressWithoutPort = portParts[0];
  const port = portParts[1];
  return port === CLOUD_DEFAULT_PROXY_PORT && proxyAddressWithoutPort === serverName;
};
exports.isCloudUrlEnabled = isCloudUrlEnabled;
const formatUrl = url => {
  var _url;
  url = ((_url = url) !== null && _url !== void 0 ? _url : '').trim().toLowerCase();
  // delete http(s):// protocol string if any
  url = url.replace(PROTOCOL_REGEX, '');
  return url;
};
const convertProxyConnectionToCloudUrl = cluster => {
  var _cluster$serverName;
  if (!isCloudUrlEnabled(cluster)) {
    return '';
  }
  return (_cluster$serverName = cluster === null || cluster === void 0 ? void 0 : cluster.serverName) !== null && _cluster$serverName !== void 0 ? _cluster$serverName : '';
};
exports.convertProxyConnectionToCloudUrl = convertProxyConnectionToCloudUrl;
const convertCloudUrlToProxyConnection = (cloudUrl = '') => {
  cloudUrl = formatUrl(cloudUrl);
  if (!cloudUrl || !(0, _validate_address.isAddressValid)(cloudUrl)) {
    return EMPTY_PROXY_VALUES;
  }
  const address = cloudUrl.split(':')[0];
  return {
    proxyAddress: `${address}:${CLOUD_DEFAULT_PROXY_PORT}`,
    serverName: address
  };
};
exports.convertCloudUrlToProxyConnection = convertCloudUrlToProxyConnection;
const validateCloudUrl = cloudUrl => {
  if (!cloudUrl) {
    return i18nTexts.urlEmpty;
  }
  cloudUrl = formatUrl(cloudUrl);
  if (!(0, _validate_address.isAddressValid)(cloudUrl)) {
    return i18nTexts.urlInvalid;
  }
  return null;
};
exports.validateCloudUrl = validateCloudUrl;