"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("./constants");
var _services = require("./services");
var _sections = require("./sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

class AppComponent extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _services.setUserHasLeftApp)(false);
    this.registerRouter();
  }
  registerRouter() {
    // Share the router with the app without requiring React or context.
    const {
      history
    } = this.props;
    (0, _services.registerRouter)({
      history,
      route: {
        location: history.location
      }
    });
  }
  componentDidMount() {
    (0, _services.trackUiMetric)(_services.METRIC_TYPE.LOADED, _constants.UIM_APP_LOAD);
  }
  componentWillUnmount() {
    // Set internal flag so we can prevent reacting to route changes internally.
    (0, _services.setUserHasLeftApp)(true);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
      history: this.props.history
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      exact: true,
      path: [`/list`, '/', ''],
      component: _sections.RemoteClusterList
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: [`/add`],
      component: _sections.RemoteClusterAdd
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
      path: `/edit/:name`,
      component: _sections.RemoteClusterEdit
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      from: `/:anything`,
      to: "/list"
    })));
  }
}
(0, _defineProperty2.default)(AppComponent, "propTypes", {
  history: _propTypes.default.shape({
    push: _propTypes.default.func.isRequired,
    createHref: _propTypes.default.func.isRequired
  }).isRequired
});
const App = AppComponent;
exports.App = App;