"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeStackTraceResponse = decodeStackTraceResponse;
exports.searchStackTraces = searchStackTraces;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function decodeStackTraceResponse(response) {
  const stackTraceEvents = new Map();
  for (const [key, value] of Object.entries((_response$stack_trace = response.stack_trace_events) !== null && _response$stack_trace !== void 0 ? _response$stack_trace : {})) {
    var _response$stack_trace;
    stackTraceEvents.set(key, value);
  }
  const stackTraces = new Map();
  for (const [key, value] of Object.entries((_response$stack_trace2 = response.stack_traces) !== null && _response$stack_trace2 !== void 0 ? _response$stack_trace2 : {})) {
    var _response$stack_trace2;
    stackTraces.set(key, {
      FrameIDs: value.frame_ids,
      FileIDs: value.file_ids,
      AddressOrLines: value.address_or_lines,
      Types: value.type_ids
    });
  }
  const stackFrames = new Map();
  for (const [key, value] of Object.entries((_response$stack_frame = response.stack_frames) !== null && _response$stack_frame !== void 0 ? _response$stack_frame : {})) {
    var _response$stack_frame;
    // Each field in a stackframe is represented by an array. This is
    // necessary to support inline frames.
    //
    // We only take the first available inline stackframe until the UI
    // can support all of them.
    stackFrames.set(key, {
      FileName: value.file_name[0],
      FunctionName: value.function_name[0],
      FunctionOffset: value.function_offset[0],
      LineNumber: value.line_number[0]
    });
  }
  const executables = new Map();
  for (const [key, value] of Object.entries((_response$executables = response.executables) !== null && _response$executables !== void 0 ? _response$executables : {})) {
    var _response$executables;
    executables.set(key, {
      FileName: value
    });
  }
  return {
    stackTraceEvents,
    stackTraces,
    stackFrames,
    executables,
    totalFrames: response.total_frames
  };
}
async function searchStackTraces({
  client,
  filter,
  sampleSize
}) {
  const response = await client.profilingStacktraces({
    query: filter,
    sampleSize
  });
  return decodeStackTraceResponse(response);
}