"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStackTraces = getStackTraces;
var _common = require("@kbn/observability-plugin/common");
var _get_executables_and_stacktraces = require("./get_executables_and_stacktraces");
var _search_stacktraces = require("./search_stacktraces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getStackTraces({
  context,
  logger,
  client,
  filter,
  sampleSize
}) {
  const core = await context.core;
  const useElasticsearchPlugin = await core.uiSettings.client.get(_common.profilingElasticsearchPlugin);
  if (useElasticsearchPlugin) {
    return await (0, _search_stacktraces.searchStackTraces)({
      client,
      filter,
      sampleSize
    });
  }
  return await (0, _get_executables_and_stacktraces.getExecutablesAndStackTraces)({
    logger,
    client,
    filter,
    sampleSize
  });
}