"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProfilingSetupSteps = getProfilingSetupSteps;
var _get_cluster_settings_step = require("./get_cluster_settings_step");
var _get_component_templates_step = require("./get_component_templates_step");
var _get_ilm_step = require("./get_ilm_step");
var _get_index_templates_step = require("./get_index_templates_step");
var _get_fleet_policy_step = require("./get_fleet_policy_step");
var _get_security_step = require("./get_security_step");
var _get_apm_package_step = require("./get_apm_package_step");
var _get_create_events_data_streams = require("./get_create_events_data_streams");
var _get_create_indices_step = require("./get_create_indices_step");
var _get_is_cloud_enabled_step = require("./get_is_cloud_enabled_step");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getProfilingSetupSteps(options) {
  return [(0, _get_is_cloud_enabled_step.getIsCloudEnabledStep)(options), (0, _get_apm_package_step.getApmPackageStep)(options), (0, _get_cluster_settings_step.getClusterSettingsStep)(options), (0, _get_ilm_step.getIlmStep)(options), (0, _get_component_templates_step.getComponentTemplatesStep)(options), (0, _get_index_templates_step.getIndexTemplatesStep)(options), (0, _get_create_events_data_streams.getCreateEventsDataStreamsStep)(options), (0, _get_create_indices_step.getCreateIndicesStep)(options), (0, _get_security_step.getSecurityStep)(options), (0, _get_fleet_policy_step.getFleetPolicyStep)(options)];
}