"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityStep = getSecurityStep;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROFILING_READER_ROLE_NAME = 'profiling-reader';
function getSecurityStep({
  client,
  logger
}) {
  const esClient = client.getEsClient();
  return {
    name: 'security',
    hasCompleted: () => {
      return esClient.security.getRole({
        name: PROFILING_READER_ROLE_NAME
      }).then(() => {
        return Promise.resolve(true);
      }, error => {
        logger.debug('Could not fetch profiling-reader role');
        logger.debug(error);
        return Promise.resolve(false);
      });
    },
    init: async () => {
      await esClient.security.putRole({
        name: PROFILING_READER_ROLE_NAME,
        indices: [{
          names: ['profiling-*'],
          privileges: ['read', 'view_index_metadata']
        }],
        cluster: ['monitor']
      });
    }
  };
}