"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIlmStep = getIlmStep;
var _catch_resource_already_exists_exception = require("./catch_resource_already_exists_exception");
var _ilm_profiling = _interopRequireDefault(require("./ilm_profiling.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LIFECYCLE_POLICY_NAME = 'profiling';
function getIlmStep({
  client,
  logger
}) {
  const esClient = client.getEsClient();
  return {
    name: 'ilm',
    hasCompleted: () => {
      return esClient.ilm.getLifecycle({
        name: LIFECYCLE_POLICY_NAME
      }).then(() => {
        return Promise.resolve(true);
      }, error => {
        logger.debug('ILM policy not installed');
        logger.debug(error);
        return Promise.resolve(false);
      });
    },
    init: async () => {
      await esClient.ilm.putLifecycle({
        name: LIFECYCLE_POLICY_NAME,
        policy: _ilm_profiling.default
      }).catch(_catch_resource_already_exists_exception.catchResourceAlreadyExistsException);
    }
  };
}