"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingComponentTemplateName = void 0;
exports.getComponentTemplatesStep = getComponentTemplatesStep;
var _component_template_profiling_ilm = _interopRequireDefault(require("./component_template_profiling_ilm.json"));
var _component_template_profiling_events = _interopRequireDefault(require("./component_template_profiling_events.json"));
var _component_template_profiling_executables = _interopRequireDefault(require("./component_template_profiling_executables.json"));
var _component_template_profiling_stackframes = _interopRequireDefault(require("./component_template_profiling_stackframes.json"));
var _component_template_profiling_stacktraces = _interopRequireDefault(require("./component_template_profiling_stacktraces.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ProfilingComponentTemplateName;
exports.ProfilingComponentTemplateName = ProfilingComponentTemplateName;
(function (ProfilingComponentTemplateName) {
  ProfilingComponentTemplateName["Ilm"] = "profiling-ilm";
  ProfilingComponentTemplateName["Events"] = "profiling-events";
  ProfilingComponentTemplateName["Executables"] = "profiling-executables";
  ProfilingComponentTemplateName["Stackframes"] = "profiling-stackframes";
  ProfilingComponentTemplateName["Stacktraces"] = "profiling-stacktraces";
})(ProfilingComponentTemplateName || (exports.ProfilingComponentTemplateName = ProfilingComponentTemplateName = {}));
function getComponentTemplatesStep({
  client,
  logger
}) {
  const esClient = client.getEsClient();
  return {
    name: 'component_templates',
    hasCompleted: async () => {
      return Promise.all([ProfilingComponentTemplateName.Ilm, ProfilingComponentTemplateName.Events, ProfilingComponentTemplateName.Executables, ProfilingComponentTemplateName.Stackframes, ProfilingComponentTemplateName.Stacktraces].map(componentTemplateName => esClient.cluster.getComponentTemplate({
        name: componentTemplateName
      }))).then(() => Promise.resolve(true), error => {
        logger.debug('Some component templates could not be fetched');
        logger.debug(error);
        return Promise.resolve(false);
      });
    },
    init: async () => {
      await Promise.all([esClient.cluster.putComponentTemplate({
        name: ProfilingComponentTemplateName.Ilm,
        create: false,
        template: _component_template_profiling_ilm.default
      }), esClient.cluster.putComponentTemplate({
        name: ProfilingComponentTemplateName.Events,
        create: false,
        template: _component_template_profiling_events.default,
        _meta: {
          description: 'Mappings for profiling events data stream'
        }
      }), esClient.cluster.putComponentTemplate({
        name: ProfilingComponentTemplateName.Executables,
        create: false,
        template: _component_template_profiling_executables.default
      }), esClient.cluster.putComponentTemplate({
        name: ProfilingComponentTemplateName.Stackframes,
        create: false,
        template: _component_template_profiling_stackframes.default
      }), esClient.cluster.putComponentTemplate({
        name: ProfilingComponentTemplateName.Stacktraces,
        create: false,
        template: _component_template_profiling_stacktraces.default
      })]);
    }
  };
}