"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClusterSettingsStep = getClusterSettingsStep;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_BUCKETS = 150000;
function getClusterSettingsStep({
  client
}) {
  return {
    name: 'cluster_settings',
    hasCompleted: async () => {
      var _settings$persistent$;
      const settings = await client.getEsClient().cluster.getSettings({});
      return ((_settings$persistent$ = settings.persistent.search) === null || _settings$persistent$ === void 0 ? void 0 : _settings$persistent$.max_buckets) === MAX_BUCKETS.toString();
    },
    init: async () => {
      await client.getEsClient().cluster.putSettings({
        persistent: {
          search: {
            max_buckets: MAX_BUCKETS
          }
        }
      });
    }
  };
}