"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmPackageStep = getApmPackageStep;
var _packages = require("@kbn/fleet-plugin/server/services/epm/packages");
var _registry = require("@kbn/fleet-plugin/server/services/epm/registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getApmPackageStep({
  client,
  soClient,
  spaceId
}) {
  const esClient = client.getEsClient();
  return {
    name: 'apm_package',
    hasCompleted: async () => {
      const installation = await (0, _packages.getInstallation)({
        pkgName: 'apm',
        savedObjectsClient: soClient
      });
      return !!installation;
    },
    init: async () => {
      const {
        name,
        version
      } = await (0, _registry.fetchFindLatestPackageOrThrow)('apm');
      await (0, _packages.installPackage)({
        installSource: 'registry',
        esClient,
        savedObjectsClient: soClient,
        pkgkey: (0, _registry.pkgToPkgKey)({
          name,
          version
        }),
        spaceId,
        force: true
      });
    }
  };
}