"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catchResourceAlreadyExistsException = catchResourceAlreadyExistsException;
var _esErrors = require("@kbn/es-errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function catchResourceAlreadyExistsException(error) {
  var _error$body, _error$body$error;
  if ((0, _esErrors.isResponseError)(error) && ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$error = _error$body.error) === null || _error$body$error === void 0 ? void 0 : _error$body$error.type) === 'resource_already_exists_exception') {
    return Promise.resolve();
  }
  return Promise.reject(error);
}