"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSetupInstructions = getSetupInstructions;
var _get_apm_policy = require("./steps/get_apm_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSetupInstructions({
  packagePolicyClient,
  soClient
}) {
  const apmPolicy = await (0, _get_apm_policy.getApmPolicy)({
    packagePolicyClient,
    soClient
  });
  if (!apmPolicy) {
    throw new Error('Could not find APM policy');
  }
  const apmServerVars = apmPolicy.inputs[0].vars;
  return {
    variables: {
      apmServerUrl: apmServerVars.url.value,
      secretToken: apmServerVars.secret_token.value
    }
  };
}