"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asWeight = asWeight;
var _i18n = require("@kbn/i18n");
var _as_number = require("./as_number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_POUND_TO_A_KILO = 0.45359237;
function asWeight(valueInPounds) {
  const lbs = (0, _as_number.asNumber)(valueInPounds);
  const kgs = (0, _as_number.asNumber)(Number(valueInPounds * ONE_POUND_TO_A_KILO));
  return _i18n.i18n.translate('xpack.profiling.formatters.weight', {
    defaultMessage: `{lbs} lbs / {kgs} kg`,
    values: {
      lbs,
      kgs
    }
  });
}