"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAsync = exports.AsyncStatus = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _react = require("react");
var _use_auto_aborted_http_client = require("./use_auto_aborted_http_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AsyncStatus;
exports.AsyncStatus = AsyncStatus;
(function (AsyncStatus) {
  AsyncStatus["Loading"] = "loading";
  AsyncStatus["Init"] = "init";
  AsyncStatus["Settled"] = "settled";
})(AsyncStatus || (exports.AsyncStatus = AsyncStatus = {}));
const useAsync = (fn, dependencies) => {
  const [refreshId, setRefreshId] = (0, _react.useState)(0);
  const refresh = (0, _react.useCallback)(() => {
    setRefreshId(id => id + 1);
  }, []);
  const [asyncState, setAsyncState] = (0, _react.useState)({
    status: AsyncStatus.Init,
    refresh
  });
  const {
    data,
    error
  } = asyncState;
  const httpClient = (0, _use_auto_aborted_http_client.useAutoAbortedHttpClient)(dependencies);
  (0, _react.useEffect)(() => {
    const returnValue = fn({
      http: httpClient
    });
    if (returnValue === undefined) {
      setAsyncState({
        status: AsyncStatus.Init,
        data: undefined,
        error: undefined,
        refresh
      });
      return;
    }
    setAsyncState({
      status: AsyncStatus.Loading,
      data,
      error,
      refresh
    });
    returnValue.then(nextData => {
      setAsyncState({
        status: AsyncStatus.Settled,
        data: nextData,
        refresh
      });
    });
    returnValue.catch(nextError => {
      if (nextError instanceof _common.AbortError) {
        return;
      }
      setAsyncState({
        status: AsyncStatus.Settled,
        error: nextError,
        refresh
      });
      throw nextError;
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [httpClient, refreshId, ...dependencies]);
  return asyncState;
};
exports.useAsync = useAsync;