"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubChart = SubChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _topn = require("../../common/topn");
var _use_kibana_timezone_setting = require("../hooks/use_kibana_timezone_setting");
var _use_profiling_charts_theme = require("../hooks/use_profiling_charts_theme");
var _use_profiling_params = require("../hooks/use_profiling_params");
var _use_profiling_router = require("../hooks/use_profiling_router");
var _as_number = require("../utils/formatters/as_number");
var _as_percentage = require("../utils/formatters/as_percentage");
var _stack_frame_summary = require("./stack_frame_summary");
var _utils = require("./stack_traces_view/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUM_DISPLAYED_FRAMES = 5;
function SubChart({
  index,
  color,
  category,
  label,
  percentage,
  height,
  data,
  width,
  showAxes,
  metadata,
  onShowMoreClick,
  style,
  showFrames,
  padTitle,
  sample
}) {
  const theme = (0, _eui.useEuiTheme)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const {
    path,
    query
  } = (0, _use_profiling_params.useProfilingParams)('/stacktraces/{topNType}');
  const href = profilingRouter.link('/stacktraces/{topNType}', (0, _utils.getTracesViewRouteParams)({
    query,
    topNType: path.topNType,
    category
  }));
  const timeZone = (0, _use_kibana_timezone_setting.useKibanaTimeZoneSetting)();
  const {
    chartsTheme,
    chartsBaseTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const compact = !!onShowMoreClick;
  const displayedFrames = compact ? metadata.concat().reverse().slice(0, NUM_DISPLAYED_FRAMES) : metadata.concat().reverse();
  const hasMoreFrames = displayedFrames.length < metadata.length;
  let bottomElement;
  if (metadata.length > 0) {
    bottomElement = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        backgroundColor: theme.euiTheme.colors.lightestShade,
        padding: theme.euiTheme.size.m
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, displayedFrames.map((frame, frameIndex) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: frame.FrameID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, metadata.indexOf(frame) + 1), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_stack_frame_summary.StackFrameSummary, {
      frame: frame
    })))), frameIndex < displayedFrames.length - 1 || hasMoreFrames ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "s"
    })) : null))), hasMoreFrames && !!onShowMoreClick && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onShowMoreClick
    }, _i18n.i18n.translate('xpack.profiling.stackTracesView.showMoreTracesButton', {
      defaultMessage: 'Show more'
    }))));
  } else if (category === _topn.OTHER_BUCKET_LABEL && showFrames) {
    bottomElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      style: {
        padding: theme.euiTheme.size.m
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.profiling.stackTracesView.otherTraces', {
      defaultMessage: '[This summarizes all traces that are too small to display]'
    }))));
  } else {
    bottomElement = /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    style: {
      ...style,
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      ...(padTitle ? {
        padding: theme.euiTheme.size.l,
        paddingBottom: theme.euiTheme.size.s
      } : {})
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    style: {
      overflowWrap: 'anywhere'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: theme.euiTheme.colors.lightestShade,
    size: "xs"
  }, index))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-start'
    }
  }, showFrames ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onShowMoreClick === null || onShowMoreClick === void 0 ? void 0 : onShowMoreClick()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, label)) : category === _topn.OTHER_BUCKET_LABEL ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, label) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, sample ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, (0, _as_percentage.asPercentage)(sample.Percentage / 100))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: sample ? 'xs' : 's'
  }, sample ? _i18n.i18n.translate('xpack.profiling.stackFrames.subChart.avg', {
    defaultMessage: 'avg. {percentage}',
    values: {
      percentage: (0, _as_percentage.asPercentage)(percentage / 100)
    }
  }) : (0, _as_percentage.asPercentage)(percentage / 100))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height,
      width
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    tooltip: {
      showNullValues: false
    },
    baseTheme: chartsBaseTheme,
    theme: chartsTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: category,
    name: category,
    data: data,
    xAccessor: 'Timestamp',
    yAccessors: ['Count'],
    xScaleType: _charts.ScaleType.Time,
    timeZone: timeZone,
    yScaleType: _charts.ScaleType.Linear,
    curve: _charts.CurveType.CURVE_STEP_AFTER,
    color: color
  }), sample ? /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "highlighted_sample",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: sample.Timestamp
    }],
    style: {
      line: {
        strokeWidth: 2,
        dash: [4, 4],
        opacity: 0.5
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot"
    }),
    markerPosition: _charts.Position.Top,
    hideTooltips: true
  }) : null, showAxes ? /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: (0, _charts.timeFormatter)('YYYY-MM-DD HH:mm:ss')
  }) : null, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    showGridLines: true,
    tickFormat: d => showAxes ? Number(d).toFixed(0) : '',
    style: showAxes ? {} : {
      tickLine: {
        visible: false
      },
      tickLabel: {
        visible: false
      },
      axisTitle: {
        visible: false
      }
    }
  })), !showAxes ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      top: 0,
      left: 0,
      backgroundColor: `rgba(255, 255, 255, 0.75)`
    }
  }, sample ? (0, _as_number.asNumber)(sample.Count) : _i18n.i18n.translate('xpack.profiling.maxValue', {
    defaultMessage: 'Max: {max}',
    values: {
      max: (0, _as_number.asNumber)(Math.max(...data.map(value => {
        var _value$Count;
        return (_value$Count = value.Count) !== null && _value$Count !== void 0 ? _value$Count : 0;
      })))
    }
  })) : null), bottomElement);
}