"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracesViewRouteParams = getTracesViewRouteParams;
var _stack_traces = require("../../../common/stack_traces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTracesViewRouteParams({
  query,
  topNType,
  category
}) {
  return {
    path: {
      topNType: _stack_traces.TopNType.Traces
    },
    query: {
      ...query,
      kuery: `${query.kuery ? `(${query.kuery}) AND ` : ''}${(0, _stack_traces.getFieldNameForTopNType)(topNType)}:"${category}"`
    }
  };
}